/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: Ecm_ErrorCodes.h 94787 2020-09-24 14:43:50Z SBormann $:


Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 yyyy-mm-dd    created
**************************************************************************************/

#ifndef _ECM_ERRORCODES_H
#define _ECM_ERRORCODES_H

#ifndef ECM_ERROR_TABLE_BEGIN
#define ECM_ERROR_TABLE_BEGIN typedef enum ECM_ERROR_CODE_Etag {
#endif

#ifndef ECM_ERROR_RESULT
#define ECM_ERROR_RESULT(x, v) x = v,
#endif

#ifndef ECM_ERROR_TABLE_END
#define ECM_ERROR_TABLE_END   ECM_ERROR_CODE_VALUE_RANGE = 0xFFFFFFFF } ECM_ERROR_CODE_E;
#endif

ECM_ERROR_TABLE_BEGIN
#ifndef ECM_ERROR_TABLE_EXCLUDE_COMMON_ERRORS
ECM_ERROR_RESULT(ECM_SUCCESS, 0)

ECM_ERROR_RESULT(ECM_ERROR_FAIL, 0xC0000001)
ECM_ERROR_RESULT(ECM_ERROR_UNEXPECTED, 0xC0000002)
ECM_ERROR_RESULT(ECM_ERROR_OUT_OF_MEMORY, 0xC0000003)
ECM_ERROR_RESULT(ECM_ERROR_UNKNOWN_COMMAND, 0xC0000004)
ECM_ERROR_RESULT(ECM_ERROR_INVALID_PARAMETER, 0xC0000009)
ECM_ERROR_RESULT(ECM_ERROR_WATCHDOG_TIMEOUT, 0xC000000C)
ECM_ERROR_RESULT(ECM_ERROR_INVALID_SEQUENCE, 0xC000000F)
ECM_ERROR_RESULT(ECM_ERROR_REQUEST_RUNNING, 0xC000001A)
ECM_ERROR_RESULT(ECM_ERROR_NOT_CONFIGURED, 0xC0000119)
ECM_ERROR_RESULT(ECM_ERROR_CONFIGURATION_FAULT, 0xC0000120)
ECM_ERROR_RESULT(ECM_ERROR_INSUFFICIENT_LICENSE, 0xC0000123)
ECM_ERROR_RESULT(ECM_ERROR_PARAMETER_ERROR, 0xC0000124)
ECM_ERROR_RESULT(ECM_ERROR_NETWORK_FAULT, 0xC0000140)
ECM_ERROR_RESULT(ECM_ERROR_CONNECTION_TIMEOUT, 0xC0000142)
ECM_ERROR_RESULT(ECM_ERROR_CABLE_DISCONNECT, 0xC0000145)
ECM_ERROR_RESULT(ECM_ERROR_BUS_OFF, 0xC0000180)
ECM_ERROR_RESULT(ECM_ERROR_CONFIG_IS_LOCKED, 0xC0000181)
#endif

/*#define TLR_UNQ_NR_ECMV4_LLD             0xCC */
ECM_ERROR_RESULT(ECM_ERROR_LLD_TIMEOUT, 0xC0CC0001)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNSUPPORTED_COMMAND, 0xC0CC0003)
ECM_ERROR_RESULT(ECM_ERROR_LLD_DUPLICATE_FIXED_STATION_ADDRESS, 0xC0CC0004)
ECM_ERROR_RESULT(ECM_ERROR_LLD_SII_CHECKSUM_ERROR, 0xC0CC0005)
ECM_ERROR_RESULT(ECM_ERROR_LLD_SII_EEPROM_LOADING_ERROR, 0xC0CC0006)
ECM_ERROR_RESULT(ECM_ERROR_LLD_SII_MISSING_ERROR_ACK, 0xC0CC0007)
ECM_ERROR_RESULT(ECM_ERROR_LLD_STATE_CHANGE_FAILED, 0xC0CC0008)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNEXPECTED_AL_STATUS, 0xC0CC0009)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNEXPECTED_WKC, 0xC0CC000A)
ECM_ERROR_RESULT(ECM_ERROR_LLD_MAILBOX_NOT_AVAILABLE, 0xC0CC000B)
ECM_ERROR_RESULT(ECM_ERROR_LLD_MAILBOX_MESSAGE_TOO_LARGE, 0xC0CC000C)
ECM_ERROR_RESULT(ECM_ERROR_LLD_CONFIGURATION_IN_PROGRESS, 0xC0CC000D)
ECM_ERROR_RESULT(ECM_ERROR_LLD_TOO_MANY_CYCLIC_FRAMES, 0xC0CC000E)
ECM_ERROR_RESULT(ECM_ERROR_LLD_CYCLIC_FRAME_EXCEEDS_MTU, 0xC0CC000F)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_CYCLIC_TELEGRAM_CONFIG, 0xC0CC0010)
ECM_ERROR_RESULT(ECM_ERROR_LLD_BUILDING_COPY_ROUTINES_FAILED, 0xC0CC0011)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNSUPPORTED_SLAVE_STATION_ADDRESS, 0xC0CC0012)
ECM_ERROR_RESULT(ECM_ERROR_LLD_STATION_ADDRESS_NOT_ALLOWED, 0xC0CC0013)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_STD_TX_MBX_PHYS_OFFSET, 0xC0CC0014)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_STD_RX_MBX_PHYS_OFFSET, 0xC0CC0015)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_BOOT_TX_MBX_PHYS_OFFSET, 0xC0CC0016)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_BOOT_RX_MBX_PHYS_OFFSET, 0xC0CC0017)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_STD_TX_MBX_SM_NO, 0xC0CC0018)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_STD_RX_MBX_SM_NO, 0xC0CC0019)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_BOOT_TX_MBX_SM_NO, 0xC0CC001A)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_BOOT_RX_MBX_SM_NO, 0xC0CC001B)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNCONFIGURED_SLAVE_STATION_ADDRESS, 0xC0CC001C)
ECM_ERROR_RESULT(ECM_ERROR_LLD_WRONG_SLAVE_STATE, 0xC0CC001D)
ECM_ERROR_RESULT(ECM_ERROR_LLD_CYCLE_TIME_TOO_SMALL, 0xC0CC001E)
ECM_ERROR_RESULT(ECM_ERROR_LLD_REPETITION_COUNT_NOT_SUPPORTED, 0xC0CC001F)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_CALLBACK_TYPE, 0xC0CC0020)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_CYCLE_MULTIPLIER, 0xC0CC0021)
ECM_ERROR_RESULT(ECM_ERROR_LLD_UNKNOWN_ERROR, 0xC0CC0022)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_REG_LENGTH, 0xC0CC0023)
ECM_ERROR_RESULT(ECM_ERROR_LLD_INVALID_PARAMETER, 0xC0CC0024)
ECM_ERROR_RESULT(ECM_ERROR_LLD_IRQ_NOT_AVAILABLE, 0xC0CC0025)
ECM_ERROR_RESULT(ECM_ERROR_LLD_IOMEM_IRQ_NOT_AVAILABLE, 0xC0CC0026)
ECM_ERROR_RESULT(ECM_ERROR_LLD_HW_INIT_FAILED, 0xC0CC0027)
ECM_ERROR_RESULT(ECM_ERROR_LLD_MUTEX_CREATION_FAILED, 0xC0CC0028)
ECM_ERROR_RESULT(ECM_ERROR_LLD_DC_RX_LATCH_COMMAND_REQUIRED_FOR_DC, 0xC0CC0029)
ECM_ERROR_RESULT(ECM_ERROR_LLD_TX_PROCESS_IMAGE_EXCEEDED, 0xC0CC002A)
ECM_ERROR_RESULT(ECM_ERROR_LLD_RX_PROCESS_IMAGE_EXCEEDED, 0xC0CC002B)
ECM_ERROR_RESULT(ECM_ERROR_LLD_MBX_STATE_IMAGE_EXCEEDED, 0xC0CC002C)
ECM_ERROR_RESULT(ECM_ERROR_LLD_RESULT_DUPLICATE_BWR_RX_LATCH_CMD, 0xC0CC002D)
ECM_ERROR_RESULT(ECM_ERROR_LLD_RESULT_DUPLICATE_EXT_SYSTIME_CONTROL_CMD, 0xC0CC002E)
ECM_ERROR_RESULT(ECM_ERROR_LLD_CC_PROCESS_IMAGE_EXCEEDED, 0xC0CC002F)
ECM_ERROR_RESULT(ECM_ERROR_LLD_SII_TIMEOUT, 0xC0CC0030)
ECM_ERROR_RESULT(ECM_ERROR_LLD_BUS_NOT_ENABLED, 0xC0CC0031)
ECM_ERROR_RESULT(ECM_ERROR_LLD_MAILBOX_MESSAGE_INVALID, 0xC0CC0032)

/* #define TLR_UNQ_NR_ECMV4_EMC             0xCD */
ECM_ERROR_RESULT(ECM_INFO_EMC_BUS_IS_OFF, 0x40CD0017)

ECM_ERROR_RESULT(ECM_ERROR_EMC_REQUEST_DESTINATION_PROBLEM, 0xC0CD0001)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_SLAVE_STATION_ADDRESS, 0xC0CD0002)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CONFIGURATION_BUFFER_IS_OPEN, 0xC0CD0003)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_STATE_FOR_RECONFIGURATION, 0xC0CD0004)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CONFIGURATION_BUFFER_IS_NOT_OPEN, 0xC0CD0005)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SLAVE_STATION_ADDRESS_ALREADY_IN_CONFIG, 0xC0CD0006)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_STD_MBX_PARAMETERS, 0xC0CD0007)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_BOOT_MBX_PARAMETERS, 0xC0CD0008)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STD_MBX_SM_ARE_OVERLAPPING, 0xC0CD0009)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BOOT_MBX_SM_ARE_OVERLAPPING, 0xC0CD000A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SM_PARAMS_ALREADY_ADDED, 0xC0CD000B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_SM_NUMBER, 0xC0CD000C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_FMMU_PARAMS_ALREADY_ADDED, 0xC0CD000D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_FMMU_NUMBER, 0xC0CD000E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_MIN_STATE, 0xC0CD000F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CYCLE_FRAME_AMOUNT_EXCEEDED, 0xC0CD0010)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_CYCLIC_FRAME_IN_CONFIGURATION, 0xC0CD0011)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CYCLE_FRAME_INDEX_NOT_VALID, 0xC0CD0012)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_TELEGRAM_LENGTH, 0xC0CD0013)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CYCLE_FRAME_LENGTH_EXCEEDED, 0xC0CD0014)
ECM_ERROR_RESULT(ECM_ERROR_EMC_AMOUNT_OF_TELEGRAMS_IN_CYCLIC_FRAME_EXCEEDED, 0xC0CD0015)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STATE_CHANGE_IN_PROGRESS, 0xC0CD0016)
ECM_ERROR_RESULT(ECM_ERROR_EMC_TOO_MANY_SLAVES_GIVEN, 0xC0CD0018)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DUPLICATE_STATION_ADDRESS_IN_LIST, 0xC0CD0019)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COMMAND_TYPE_NOT_ALLOWED_FOR_SLAVE_FSM, 0xC0CD001A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CONFIGURATION_DATA_INCORRECT, 0xC0CD001B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_VENDORID_MISMATCH, 0xC0CD001C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_PRODUCTCODE_MISMATCH, 0xC0CD001D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_REVISIONNO_MISMATCH, 0xC0CD001E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SERIALNO_MISMATCH, 0xC0CD001F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_LOST_CONNECTION, 0xC0CD0020)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNKNOWN_STATE_CHANGE_HAPPENED, 0xC0CD0021)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_STATE_CHANGE_HAPPENED, 0xC0CD0022)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SLAVE_CHANGED_STATE, 0xC0CD0023)
ECM_ERROR_RESULT(ECM_ERROR_EMC_FILE_PROVIDER_INIT_FAILED, 0xC0CD0024)
#define ECM_ERROR_EMC_INVALID_SLAVE_ADDRESS ECM_ERROR_EMC_INVALID_SLAVE_STATION_ADDRESS
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_TIMESTAMP_ERROR, 0xC0CD0026)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_ERROR, 0xC0CD0027)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_SLAVE_INDEX, 0xC0CD0028)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_MASTER_STATE, 0xC0CD0029)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_TRANSFER_ID, 0xC0CD002A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_SEGMENTATION, 0xC0CD002B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EOE_IP_PARAMS_ALREADY_ADDED, 0xC0CD002C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EOE_SUPPORT_NOT_AVAILABLE, 0xC0CD002D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_END_CONFIGURATION_IN_PROGRESS, 0xC0CD002E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_IS_ON, 0xC0CD002F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_SCAN_ACTIVE, 0xC0CD0030)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_STATE_FOR_RECONFIGURATION_IN_PROGRESS_TO_BUSOFF, 0xC0CD0031)
ECM_ERROR_RESULT(ECM_ERROR_EMC_NO_DIAG_ENTRY_AVAILABLE, 0xC0CD0032)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SLAVE_SYNC_PARAMS_NOT_POSSIBLE_WITHOUT_WORKING_DC, 0xC0CD0033)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MANDATORY_SLAVE_MISSING, 0xC0CD0034)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WRONG_SLAVE_AT_POSITION, 0xC0CD0035)
ECM_ERROR_RESULT(ECM_ERROR_EMC_NO_DC_REF_CLOCK, 0xC0CD0036)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_REF_CLOCK_DOES_NOT_PROVIDE_64BIT, 0xC0CD0037)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_DC_REF_CLOCK, 0xC0CD0038)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COE_SUPPORT_NOT_AVAILABLE, 0xC0CD0039)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SOE_SUPPORT_NOT_AVAILABLE, 0xC0CD003A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_FOE_SUPPORT_NOT_AVAILABLE, 0xC0CD003B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_AOE_SUPPORT_NOT_AVAILABLE, 0xC0CD003C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WDG_ERROR, 0xC0CD003D)
ECM_ERROR_RESULT(ECM_INFO_EMC_RECONNECTED, 0x40CD003E)
ECM_ERROR_RESULT(ECM_WARN_EMC_DC_STOPPED, 0x80CD003F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STOPPED_DUE_SYNC_ERROR, 0xC0CD0040)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MANDATORY_SLAVE_NOT_IN_OP, 0xC0CD0041)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BUS_CYCLE_TIME_NOT_POSSIBLE, 0xC0CD0042)
ECM_ERROR_RESULT(ECM_ERROR_EMC_TOPOLOGY_ERROR_DETECTED, 0xC0CD0043)
ECM_ERROR_RESULT(ECM_ERROR_EMC_TOPOLOGY_MISMATCH_DETECTED, 0xC0CD0044)
ECM_ERROR_RESULT(ECM_ERROR_EMC_NO_VALID_TOPOLOGY_CONFIGURATION_DATA, 0xC0CD0045)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0, 0xC0CD0046)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT1, 0xC0CD0047)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT2, 0xC0CD0048)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT3, 0xC0CD0049)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_CONNECTED, 0xC0CD004A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0, 0xC0CD004B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT1, 0xC0CD004C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT2, 0xC0CD004D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT3, 0xC0CD004E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SLAVE_NOT_CHECKED, 0xC0CD004F)

ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_1, 0xC0CD0050)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_2, 0xC0CD0051)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_3, 0xC0CD0052)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT1_2, 0xC0CD0053)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT1_3, 0xC0CD0054)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT2_3, 0xC0CD0055)

ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_2, 0xC0CD0056)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_3, 0xC0CD0057)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT0_2_3, 0xC0CD0058)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNEXPECTED_SLAVE_AT_PORT1_2_3, 0xC0CD0059)

ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_1, 0xC0CD005A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_2, 0xC0CD005B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_3, 0xC0CD005C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT1_2, 0xC0CD005D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT1_3, 0xC0CD005E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT2_3, 0xC0CD005F)

ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_1_2, 0xC0CD0060)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_1_3, 0xC0CD0061)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT0_2_3, 0xC0CD0062)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_SLAVE_AT_PORT1_2_3, 0xC0CD0063)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COMMAND_TYPE_NOT_ALLOWED_FOR_TOPOLOGY_FSM, 0xC0CD0064)
ECM_ERROR_RESULT(ECM_ERROR_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MANDATORY_SLAVE_LIST, 0xC0CD0065)
ECM_ERROR_RESULT(ECM_ERROR_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MULTIPLE_HC_GROUPS, 0xC0CD0066)
ECM_ERROR_RESULT(ECM_ERROR_EMC_HC_GROUP_HEAD_IS_NOT_LISTED_FOR_HC_DETECTION, 0xC0CD0067)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_SETUP_CALCULATION_ERROR, 0xC0CD0068)
ECM_ERROR_RESULT(ECM_ERROR_EMC_NON_DC_SLAVE_MORE_THAN_2_PORTS_IN_DC_SETUP, 0xC0CD0069)
ECM_ERROR_RESULT(ECM_ERROR_EMC_HC_GROUP_CONTAINS_NOT_CONFIGURED_SLAVE, 0xC0CD006A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_ALCONTROL_TIMEOUT, 0xC0CD006B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MEASUREMENT_ERROR, 0xC0CD006C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_RX_DESTINATION_EXCEEDS_RX_IMAGE_SIZE, 0xC0CD006D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_TX_SOURCE_EXCEEDS_TX_IMAGE_SIZE, 0xC0CD006E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WCSTATEBIT_EXCEEDS_RX_IMAGE_SIZE, 0xC0CD006F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_WKC_MAPPING_EXCEEDS_RX_IMAGE_SIZE, 0xC0CD0070)

ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0, 0xC0CD0071)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT1, 0xC0CD0072)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT2, 0xC0CD0073)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT3, 0xC0CD0074)

ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1, 0xC0CD0075)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2, 0xC0CD0076)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_3, 0xC0CD0077)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2, 0xC0CD0078)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT1_3, 0xC0CD0079)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT2_3, 0xC0CD007A)

ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2, 0xC0CD007B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_3, 0xC0CD007C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2_3, 0xC0CD007D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2_3, 0xC0CD007E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2_3, 0xC0CD007F)

ECM_ERROR_RESULT(ECM_ERROR_EMC_ASSIGN_PDO_IS_MISSING_PDO_MAPPING, 0xC0CD0080)

ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_OBJ_IS_NOT_MAPPED_TO_SAME_SM, 0xC0CD0081)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DUPLICATE_EXT_SYNC_OBJ, 0xC0CD0082)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNSUPPORTED_EXT_SYNC_OBJ_RECORD, 0xC0CD0083)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNSUPPORTED_MAPPING_OF_EXT_SYNC_OBJ_RECORD, 0xC0CD0084)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MISSING_MAPPING_OF_EXT_SYNC_OBJ_RECORD, 0xC0CD0085)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_OBJ_IS_NOT_MAPPED_TO_SAME_FMMU, 0xC0CD0086)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_OBJ_INTERNAL_ERROR, 0xC0CD0087)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_OBJ_IS_NOT_MAPPED_IN_ONE_CYCLIC_CMD, 0xC0CD0088)
ECM_ERROR_RESULT(ECM_ERROR_EMC_UNSUPPORTED_FMMU_MAPPING_OF_EXT_SYNC_OBJ_RECORD, 0xC0CD0089)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_REQUIRES_ADJUST_EXT_SYNC_CMD, 0xC0CD008A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_CMD_DOES_NOT_MATCH_XRMW_CMD, 0xC0CD008B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXT_SYNC_REQUIRES_XRMW_CMD, 0xC0CD008C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXPLICIT_DEV_IDENT_FAILED_ALSTATUS, 0xC0CD008D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_EXPLICIT_DEV_IDENT_FAILED_REG, 0xC0CD008E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COPY_INFOS_FOUND_AT_UNMAPPED_RECEIVE_DATA, 0xC0CD008F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COPY_INFO_RECEIVE_DATA_AREA_NOT_MATCHING, 0xC0CD0090)

ECM_ERROR_RESULT(ECM_ERROR_EMC_SDO_UPLOAD_TOO_LONG, 0xC0CD0091)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SDO_UPLOAD_TOO_SHORT, 0xC0CD0092)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SDO_UPLOAD_COMPARE_DOES_NOT_MATCH_EXPECTATION, 0xC0CD0093)

ECM_ERROR_RESULT(ECM_ERROR_EMC_SOE_READ_TOO_LONG, 0xC0CD0094)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SOE_READ_TOO_SHORT, 0xC0CD0095)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SOE_READ_COMPARE_DOES_NOT_MATCH_EXPECTATION, 0xC0CD0096)

ECM_ERROR_RESULT(ECM_ERROR_EMC_REG_INITCMD_COMPARE_DOES_NOT_MATCH_EXPECTATION, 0XC0CD0097)
ECM_ERROR_RESULT(ECM_ERROR_EMC_REDUNDANCY_PORT_ONLY_POSSIBLE_ONCE, 0xC0CD0098)

ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_SCAN_SII_FAILED, 0xC0CD0099)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_VERIFY_SII_FAILED, 0xC0CD009A)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MAIN_PORT_NOT_CONNECTED, 0xC0CD009B)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BUS_SCAN_TOO_MANY_SLAVES, 0xC0CD009C)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BUS_SCAN_SPLIT_RING_NOT_SUPPORTED, 0xC0CD009D)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BUS_SHUTDOWN, 0xC0CD009E)
ECM_ERROR_RESULT(ECM_ERROR_EMC_MASTER_ADDRESS_NOT_ALLOWED_AS_STATION_ADDRESS, 0xC0CD009F)
ECM_ERROR_RESULT(ECM_ERROR_EMC_FIRST_STATION_HAS_INVALID_PORT_0, 0xC0CD00A0)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STATION_HAS_INVALID_PORT, 0xC0CD00A1)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STATION_HAS_NOT_LISTED_STATION_ADDRESS_IN_PORT, 0xC0CD00A2)
ECM_ERROR_RESULT(ECM_ERROR_EMC_PORT_CONNECTION_BETWEEN_STATIONS_DOES_NOT_MATCH, 0xC0CD00A3)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STATION_HAS_ALREADY_USED_STATION_ADDRESS_IN_PORT, 0xC0CD00A4)
ECM_ERROR_RESULT(ECM_ERROR_EMC_INVALID_SM_PHYS_START_ADDRESS, 0xC0CD00A5)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_TOPOLOGY_ON_REDUNDANCY_PORT_NOT_SUPPORTED, 0xC0CD00A6)

ECM_ERROR_RESULT(ECM_ERROR_EMC_SM_ASSIGN_PDO_ALREADY_ADDED, 0xC0CD00A7)
ECM_ERROR_RESULT(ECM_ERROR_EMC_BASE_SYNC_OFFSET_PERCENTAGE_OUT_OF_RANGE, 0xC0CD00A8)
ECM_ERROR_RESULT(ECM_ERROR_EMC_COPY_INFOS_INVALID, 0xC0CD00A9)
ECM_ERROR_RESULT(ECM_ERROR_EMC_CALCULATE_DC_ERROR_TEST, 0xC0CD00AA)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_READ_TOPO_STATUS_FAILED, 0xC0CD00AB)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_ASSIGN_ADDRESSES_FAILED, 0xC0CD00AC)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_VERIFY_ADDRESSES_FAILED, 0xC0CD00AD)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_ASSIGN_SII_TO_ECAT_FAILED, 0xC0CD00AE)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_CHECK_SII_IDLE_FAILED, 0xC0CD00AF)

ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T00R00, 0xC0CD00B0)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T00R01, 0xC0CD00B1)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T00R10, 0xC0CD00B2)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T00R11, 0xC0CD00B3)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T01R00, 0xC0CD00B4)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T01R01, 0xC0CD00B5)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T01R10, 0xC0CD00B6)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T01R11, 0xC0CD00B7)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T10R00, 0xC0CD00B8)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T10R01, 0xC0CD00B9)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T10R10, 0xC0CD00BA)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T10R11, 0xC0CD00BB)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T11R00, 0xC0CD00BC)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T11R01, 0xC0CD00BD)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T11R10, 0xC0CD00BE)
ECM_ERROR_RESULT(ECM_ERROR_EMC_DC_MASTER_PORT_TIMESTAMP_LATCH_ERROR_T11R11, 0xC0CD00BF)

ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_CLEAR_STATION_ADDRESS_FAILED, 0xC0CD00C0)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_DL_CTRL_AUTO_CLOSE_FAILED, 0xC0CD00C1)
ECM_ERROR_RESULT(ECM_ERROR_EMC_STARTUP_TOO_MANY_SLAVES_DETECTED, 0xC0CD00C2)
ECM_ERROR_RESULT(ECM_ERROR_EMC_SLAVE_RESTART, 0xC0CD00C3)

/* #define TLR_UNQ_NR_ECMV4_ENI             0xD4 */
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_OPENING_TAG, 0xC0D40001)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_OPENING_TAG_IN_NUMBER_FIELD, 0xC0D40002)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_SINGLE_TAG_IN_NUMBER_FIELD, 0xC0D40003)
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_NUMBER_FIELD_TAG, 0xC0D40004)
ECM_ERROR_RESULT(ECM_ERROR_ENI_NUMBER_FIELD_IS_INVALID, 0xC0D40005)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_OPENING_TAG_IN_STRING_FIELD, 0xC0D40006)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_SINGLE_TAG_IN_STRING_FIELD, 0xC0D40007)
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_STRING_FIELD_TAG, 0xC0D40008)
ECM_ERROR_RESULT(ECM_ERROR_ENI_DATA_FIELD_IS_NOT_A_HEX_STRING, 0xC0D40009)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_OPENING_TAG_IN_DATA_FIELD, 0xC0D4000A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_SINGLE_TAG_IN_DATA_FIELD, 0xC0D4000B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_DATA_FIELD_TAG, 0xC0D4000C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INTERNAL_ERROR, 0xC0D4000D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_PREMATURE_END_OF_FILE, 0xC0D4000E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_END_OF_FILE, 0xC0D4000F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_XML, 0xC0D40010)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_SINGLE_TAG_IN_ECAT_INITCMD_BLOCK, 0xC0D40011)
ECM_ERROR_RESULT(ECM_ERROR_ENI_DUPLICATE_TAG_IN_ECAT_INITCMD_BLOCK, 0xC0D40012)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_OPENING_TAG_IN_ECAT_INITCMD_BLOCK, 0xC0D40013)
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_ECAT_INITCMD_TAG, 0xC0D40014)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_TRANSITION_IN_ECAT_INITCMD_BLOCK, 0xC0D40015)
ECM_ERROR_RESULT(ECM_ERROR_ENI_ECAT_INITCMD_IS_INCOMPLETE, 0xC0D40016)
ECM_ERROR_RESULT(ECM_ERROR_ENI_ECAT_INITCMD_VALIDATE_BLOCK_IS_INVALID, 0xC0D40017)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_SINGLE_TAG_IN_ECAT_INITCMD_VALIDATE_BLOCK, 0xC0D40018)
ECM_ERROR_RESULT(ECM_ERROR_ENI_DUPLICATE_TAG_IN_ECAT_INITCMD_VALIDATE_BLOCK, 0xC0D40019)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_OPENING_TAG_IN_ECAT_INITCMD_VALIDATE_BLOCK, 0xC0D4001A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_CLOSING_TAG_DOES_NOT_MATCH_ECAT_INITCMD_VALIDATE_TAG, 0xC0D4001B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_XML_FILE_IS_NOT_AN_ENI_XML, 0xC0D4001C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_ETHERCATCONFIG_BLOCK, 0xC0D4001D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CONFIG_BLOCK, 0xC0D4001E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_MASTER_BLOCK, 0xC0D4001F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_MASTER_INITCMDS_BLOCK, 0xC0D40020)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_BLOCK, 0xC0D40021)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INITCMDS_BLOCK, 0xC0D40022)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_BLOCK, 0xC0D40023)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_BLOCK, 0xC0D40024)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_DC_BLOCK, 0xC0D40025)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_HOTCONNECT_BLOCK, 0xC0D40026)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_PREVIOUSPORT_BLOCK, 0xC0D40027)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CYCLIC_BLOCK, 0xC0D40028)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CYCLIC_FRAME_BLOCK, 0xC0D40029)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CYCLIC_FRAME_CMD_BLOCK, 0xC0D4002A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_COE_BLOCK, 0xC0D4002B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_COE_INITCMDS_BLOCK, 0xC0D4002C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_COE_INITCMD_BLOCK, 0xC0D4002D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_SOE_BLOCK, 0xC0D4002E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_SOE_INITCMDS_BLOCK, 0xC0D4002F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_SOE_INITCMD_BLOCK, 0xC0D40030)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_EOE_BLOCK, 0xC0D40031)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_EOE_INITCMDS_BLOCK, 0xC0D40032)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_EOE_INITCMD_BLOCK, 0xC0D40033)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_AOE_BLOCK, 0xC0D40034)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_AOE_INITCMDS_BLOCK, 0xC0D40035)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_AOE_INITCMD_BLOCK, 0xC0D40036)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_FOE_BLOCK, 0xC0D40037)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_FOE_INITCMDS_BLOCK, 0xC0D40038)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_FOE_INITCMD_BLOCK, 0xC0D40039)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_VOE_BLOCK, 0xC0D4003A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_VOE_INITCMDS_BLOCK, 0xC0D4003B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_VOE_INITCMD_BLOCK, 0xC0D4003C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_LOADING_NOT_ENABLED, 0xC0D4003D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_COULD_NOT_OPEN_FILE, 0xC0D4003E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_BASE_CYCLE_TIME_TOO_SMALL, 0xC0D4003F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_PREVIOUSPORT_BLOCK, 0xC0D40040)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_PORT_IN_SLAVE_INFO_PREVIOUSPORT_BLOCK, 0xC0D40041)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_PHYSADDR_IN_SLAVE_INFO_PREVIOUSPORT_BLOCK, 0xC0D40042)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_TRANSITION_IN_COE_INITCMD_BLOCK, 0xC0D40043)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_TRANSITIONS_IN_COE_INITCMD_BLOCK, 0xC0D40044)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_CCS_IN_COE_INITCMD_BLOCK, 0xC0D40045)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_SEND_BLOCK, 0xC0D40046)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_RECV_BLOCK, 0xC0D40047)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_MAILBOX_BOOTSTRAP_BLOCK, 0xC0D40048)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_EOE_INITCMD, 0xC0D40049)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_MASTER_MAILBOXSTATES_BLOCK, 0xC0D4004A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_PROCESSDATA_BLOCK, 0xC0D4004B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_MBOX_STATE_BIT_NO_IN_SLAVE_INFO_PROCESSDATA_RECV_BLOCK, 0xC0D4004C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_PROCESS_DATA_CONFIG_OFFSET_NOT_POSSIBLE, 0xC0D4004D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_TRANSITIONS_IN_SOE_INITCMD_BLOCK, 0xC0D4004E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_OPCODE_IN_SOE_INITCMD_BLOCK, 0xC0D4004F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNSUPPORTED_ECAT_CMD_IN_IDENTIFYCMD_BLOCK, 0xC0D40050)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNSUPPORTED_ECAT_REG_IN_IDENTIFYCMD_BLOCK, 0xC0D40051)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_IDENTIFYCMD_DATA_FOR_HOT_CONNECT_SLAVE, 0xC0D40052)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_IDENTIFYCMD_DATA_FOR_HOT_CONNECT_SLAVE, 0xC0D40053)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_SM_BLOCK, 0xC0D40054)
ECM_ERROR_RESULT(ECM_ERROR_ENI_TOO_MANY_PDOS_LISTED_IN_SLAVE_INFO_SM_BLOCK, 0xC0D40055)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_PDO_BLOCK, 0xC0D40056)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_SLAVE_INFO_PDO_ENTRY_BLOCK, 0xC0D40057)
ECM_ERROR_RESULT(ECM_ERROR_ENI_TOO_MANY_PDO_ENTRIES_LISTED_IN_SLAVE_INFO_PDO_BLOCK, 0xC0D40058)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INDEX_OF_PDO_ENTRY_INVALID, 0xC0D40059)
ECM_ERROR_RESULT(ECM_ERROR_ENI_SUBINDEX_OF_PDO_ENTRY_INVALID, 0xC0D4005A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_BIT_LENGTH_OF_PDO_ENTRY_EXCEEDS_MAXIMUM_BIT_LENGTH, 0xC0D4005B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_NO_SLAVES_IN_ENI, 0xC0D4005C)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CYCLIC_FRAME_CMD_COPYINFOS_BLOCK, 0xC0D4005D)
ECM_ERROR_RESULT(ECM_ERROR_ENI_UNEXPECTED_CLOSING_TAG_IN_CYCLIC_FRAME_CMD_COPYINFOS_COPYINFO_BLOCK, 0xC0D4005E)
ECM_ERROR_RESULT(ECM_ERROR_ENI_DUPLICATE_TAG_IN_CYCLIC_FRAME_CMD_COPYINFOS_COPYINFO_BLOCK, 0xC0D4005F)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_COPYINFO_BLOCK, 0xC0D40060)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_ATTRIBUTE_IN_ECAT_INITCMD_VALIDATE_BLOCK, 0xC0D40061)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_TRANSITION_IN_VOE_INITCMD_BLOCK, 0xC0D40062)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_TRANSITIONS_IN_VOE_INITCMD_BLOCK, 0xC0D40063)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_DATA_IN_VOE_INITCMD_BLOCK, 0xC0D40064)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_NETID_IN_AOE_BLOCK, 0xC0D40065)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_TRANSITION_IN_AOE_INITCMD_BLOCK, 0xC0D40066)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_TRANSITIONS_IN_AOE_INITCMD_BLOCK, 0xC0D40067)
ECM_ERROR_RESULT(ECM_ERROR_ENI_MISSING_DATA_IN_AOE_INITCMD_BLOCK, 0xC0D40068)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_BEFORE_SLAVE_VALUE, 0xC0D40069)
ECM_ERROR_RESULT(ECM_ERROR_ENI_INVALID_COMPLETE_ACCESS_ATTRIBUTE, 0xC0D4006A)
ECM_ERROR_RESULT(ECM_ERROR_ENI_ECAT_INITCMD_MISSING_TRANSITIONS, 0xC0D4006B)
ECM_ERROR_RESULT(ECM_ERROR_ENI_AT_LEAST_ONE_SLAVE_REQUIRES_XRMW, 0xC0D4006C)

/* #define TLR_UNQ_NR_ECMV4_COE             0xCF */
ECM_ERROR_RESULT(ECM_ERROR_COE_INITIALIZATION_ERROR, 0xC0CF0001)
ECM_ERROR_RESULT(ECM_ERROR_COE_INVALID_TRANSFER_HANDLE, 0xC0CF0002)
ECM_ERROR_RESULT(ECM_ERROR_COE_NO_MAILBOX_AVAILABLE, 0xC0CF0003)
ECM_ERROR_RESULT(ECM_ERROR_COE_INVALID_TRANSFER_STATE, 0xC0CF0004)
ECM_ERROR_RESULT(ECM_ERROR_COE_TRANSFER_SEGMENT_TOO_LONG, 0xC0CF0005)
ECM_ERROR_RESULT(ECM_ERROR_COE_SHUTTING_DOWN, 0xC0CF0006)
ECM_ERROR_RESULT(ECM_ERROR_COE_MAX_TOTAL_BYTES_SMALLER_THAN_ACTUAL_TOTAL_BYTES, 0xC0CF0007)
ECM_ERROR_RESULT(ECM_ERROR_COE_MAILBOX_TRANSMIT_FAILED, 0xC0CF0008)
ECM_ERROR_RESULT(ECM_ERROR_COE_TRANSFER_ABORTED, 0xC0CF0009)
ECM_ERROR_RESULT(ECM_ERROR_COE_SDOINFO_INITIALIZATION_ERROR, 0xC0CF000A)
ECM_ERROR_RESULT(ECM_ERROR_COE_WRONG_SLAVE_STATE, 0xC0CF000B)
ECM_ERROR_RESULT(ECM_ERROR_COE_PROTOCOL_ERROR, 0xC0CF000C)
ECM_ERROR_RESULT(ECM_ERROR_COE_NO_AOE_AVAILABLE, 0xC0CF000D)
ECM_ERROR_RESULT(ECM_ERROR_COE_REQUEST_DESTINATION_PROBLEM, 0xC0CF000E)
ECM_ERROR_RESULT(ECM_ERROR_COE_INVALID_SLAVE_STATION_ADDRESS, 0xC0CF000F)

ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_TOGGLE_BIT_NOT_ALTERNATED, 0xC0CF8000)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_COMMAND_SPECIFIER_NOT_VALID, 0xC0CF8001)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_PROTOCOL_TIMEOUT, 0xC0CF8002)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OUT_OF_MEMORY, 0xC0CF8003)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_UNSUPPORTED_ACCESS, 0xC0CF8004)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_IS_WRITE_ONLY, 0xC0CF8005)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_IS_READ_ONLY, 0xC0CF8006)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_SUBINDEX_CANNOT_BE_WRITTEN_SI0_NZ, 0xC0CF8007)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_COMPLETE_ACCESS_NOT_SUPPORTED, 0xC0CF8008)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_LENGTH_EXCEEDS_MAILBOX_SIZE, 0xC0CF8009)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_MAPPED_TO_RXPDO_NO_WRITE, 0xC0CF800A)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_DOES_NOT_EXIST, 0xC0CF800B)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_OBJECT_CANNOT_BE_PDO_MAPPED, 0xC0CF800C)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_PDO_LENGTH_WOULD_EXCEED, 0xC0CF800D)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_GEN_PARAM_INCOMPATIBILITY, 0xC0CF800E)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_ACCESS_FAILED_DUE_TO_HW_ERROR, 0xC0CF800F)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_DATATYPE_DOES_NOT_MATCH, 0xC0CF8010)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_DATATYPE_LENGTH_TOO_LONG, 0xC0CF8011)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_DATATYPE_LENGTH_TOO_SHORT, 0xC0CF8012)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_SUBINDEX_DOES_NOT_EXIST, 0xC0CF8013)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_RANGE_OF_PARAMETER_EXCEEDED, 0xC0CF8014)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_HIGH, 0xC0CF8015)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_LOW, 0xC0CF8016)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_MIN_VALUE_IS_LESS_THAN_MAX_VALUE, 0xC0CF8017)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_GENERAL_ERROR, 0xC0CF8018)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_NO_TRANSFER_TO_APP, 0xC0CF8019)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_LOCAL_CONTROL, 0xC0CF801A)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_NO_TRANSFER_DUE_TO_CURRENT_STATE, 0xC0CF801B)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_NO_OBJECT_DICTIONARY_PRESENT, 0xC0CF801C)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_UNKNOWN_ABORT_CODE, 0xC0CF801D)
ECM_ERROR_RESULT(ECM_ERROR_COE_ABORTCODE_GEN_INTERNAL_INCOMPAT, 0xC0CF801E)

/* #define TLR_UNQ_NR_ECMV4_SOE             0xD2 */
ECM_ERROR_RESULT(ECM_ERROR_SOE_UNKNOWN_SOE_ERROR, 0xC0D20001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_INITIALIZATION_ERROR, 0xC0D20002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_INVALID_TRANSFER_HANDLE, 0xC0D20003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_NO_MAILBOX_AVAILABLE, 0xC0D20004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_INVALID_TRANSFER_STATE, 0xC0D20005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_TRANSFER_SEGMENT_TOO_LONG, 0xC0D20006)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SHUTTING_DOWN, 0xC0D20007)
ECM_ERROR_RESULT(ECM_ERROR_SOE_MAX_TOTAL_BYTES_SMALLER_THAN_ACTUAL_TOTAL_BYTES, 0xC0D20008)
ECM_ERROR_RESULT(ECM_ERROR_SOE_MAILBOX_TRANSMIT_FAILED, 0xC0D20009)
ECM_ERROR_RESULT(ECM_ERROR_SOE_INVALID_SOE_HEADER, 0xC0D2000A)
ECM_ERROR_RESULT(ECM_ERROR_SOE_PROTOCOL_TIMEOUT, 0xC0D2000B)
ECM_ERROR_RESULT(ECM_ERROR_SOE_PROTOCOL_ERROR, 0xC0D2000C)
ECM_ERROR_RESULT(ECM_ERROR_SOE_TRANSFER_ABORTED, 0xC0D2000D)
ECM_ERROR_RESULT(ECM_ERROR_SOE_WRONG_SLAVE_STATE, 0xC0D2000E)
ECM_ERROR_RESULT(ECM_ERROR_SOE_REQUEST_DESTINATION_PROBLEM, 0xC0D2000F)
ECM_ERROR_RESULT(ECM_ERROR_SOE_NO_AOE_AVAILABLE, 0xC0D20010)
ECM_ERROR_RESULT(ECM_ERROR_SOE_INVALID_SLAVE_STATION_ADDRESS, 0xC0D20011)

#ifndef _ECM_ERROR_RESULT_SKIP_MAP_AREA_CODES_
ECM_ERROR_RESULT(ECM_ERROR_SOE_MAPPED_START, 0xC0D21000)
#endif
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NO_IDN, 0xC0D21001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_INVALID_ACCESS_TO_ELEMENT_1, 0xC0D21009)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NO_NAME, 0xC0D22001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NAME_TRANSMISSION_IS_TOO_SHORT, 0xC0D22002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NAME_TRANSMISSION_IS_TOO_LONG, 0XC0D22003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NAME_CANNOT_BE_CHANGED, 0xC0D22004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NAME_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D22005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_SHORT, 0xC0D23002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_ATTRIBUTE_TRANSMISSION_IS_TOO_LONG, 0xC0D23003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_ATTRIBUTE_CANNOT_BE_CHANGED, 0xC0D23004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_ATTRIBUTE_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D23005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NO_UNIT, 0xC0D24001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_SHORT, 0xC0D24002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_UNIT_TRANSMISSION_IS_TOO_LONG, 0xC0D24003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_UNIT_CANNOT_BE_CHANGED, 0xC0D24004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_UNIT_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D24005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NO_MINIMUM_VALUE, 0xC0D25001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT, 0xC0D25002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MINIMUM_VALUE_TRANSMISSION_IS_TOO_LONG, 0xC0D25003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MINIMUM_VALUE_CANNOT_BE_CHANGED, 0xC0D25004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MINIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D25005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_NO_MAXIMUM_VALUE, 0xC0D26001)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_SHORT, 0xC0D26002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MAXIMUM_VALUE_TRANSMISSION_IS_TOO_LONG, 0xC0D26003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MAXIMUM_VALUE_CANNOT_BE_CHANGED, 0xC0D26004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_MAXIMUM_VALUE_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D26005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_SHORT, 0xC0D27002)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_TRANSMISSION_IS_TOO_LONG, 0xC0D27003)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_CANNOT_BE_CHANGED, 0xC0D27004)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_THIS_TIME, 0xC0D27005)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_LOWER_THAN_MINIMUM_VALUE, 0xC0D27006)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_HIGHER_THAN_MAXIMUM_VALUE, 0xC0D27007)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_INVALID, 0xC0D27008)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_BY_PASSWORD, 0xC0D27009)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_CYCLICALLY_CONFIGURED, 0xC0D2700A)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_INVALID_INDIRECT_ADDRESSING, 0xC0D2700B)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_DUE_OTHER_SETTINGS, 0xC0D2700C)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_INVALID_FLOATING_POINT_NUMBER, 0xC0D2700D)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_PARAMETERIZATION_LEVEL, 0xC0D2700E)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_IS_WRITE_PROTECTED_AT_OPERATION_LEVEL, 0xC0D2700F)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_PROCEDURE_COMMAND_ALREADY_ACTIVE, 0xC0D27010)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_INTERRUPTIBLE, 0xC0D27011)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_AT_THIS_TIME, 0xC0D27012)
ECM_ERROR_RESULT(ECM_ERROR_SOE_SSC_OPDATA_PROCEDURE_COMMAND_NOT_EXECUTABLE_INVALID_PARAM, 0xC0D27013)
#ifndef _ECM_ERROR_RESULT_SKIP_MAP_AREA_CODES_
ECM_ERROR_RESULT(ECM_ERROR_SOE_MAPPED_END, 0xC0D2FFFF)
#endif

/*
#define TLR_UNQ_NR_ECMV4_VOE             0xD3
*/

/*
#define TLR_UNQ_NR_ECMV4_FOE             0xD1
*/
ECM_ERROR_RESULT(ECM_ERROR_FOE_INITIALIZATION_ERROR, 0xC0D10001)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_UNKNOWN_ERROR, 0xC0D10002)
ECM_ERROR_RESULT(ECM_ERROR_FOE_INVALID_TRANSFER_HANDLE, 0xC0D10003)
ECM_ERROR_RESULT(ECM_ERROR_FOE_INVALID_TRANSFER_STATE, 0xC0D10004)
ECM_ERROR_RESULT(ECM_ERROR_FOE_INVALID_SLAVE_STATION_ADDRESS, 0xC0D10005)
ECM_ERROR_RESULT(ECM_ERROR_FOE_WRONG_SLAVE_STATE, 0xC0D10006)
ECM_ERROR_RESULT(ECM_ERROR_FOE_NO_MAILBOX_AVAILABLE, 0xC0D10007)
ECM_ERROR_RESULT(ECM_ERROR_FOE_TRANSFER_ABORTED, 0xC0D10008)
ECM_ERROR_RESULT(ECM_ERROR_FOE_PROTOCOL_TIMEOUT, 0xC0D10009)
ECM_ERROR_RESULT(ECM_ERROR_FOE_TRANSFER_SEGMENT_TOO_LONG, 0xC0D1000A)
ECM_ERROR_RESULT(ECM_ERROR_FOE_MAILBOX_TRANSMIT_FAILED, 0xC0D1000B)
ECM_ERROR_RESULT(ECM_ERROR_FOE_FILENAME_TOO_LONG, 0xC0D1000C)
ECM_ERROR_RESULT(ECM_ERROR_FOE_BUFFER_EXCEEDED, 0xC0D1000D)
ECM_ERROR_RESULT(ECM_ERROR_FOE_FIRST_SEGMENT_SHOULD_NOT_BE_EMPTY, 0xC0D1000E)
ECM_ERROR_RESULT(ECM_ERROR_FOE_SEGMENT_SHOULD_BE_EMPTY, 0xC0D1000F)
ECM_ERROR_RESULT(ECM_ERROR_FOE_REQUEST_DESTINATION_PROBLEM, 0XC0D1010)

ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NOT_DEFINED, 0xC0D18000)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NOT_FOUND, 0xC0D18001)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_ACCESS_DENIED, 0xC0D18002)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_DISK_FULL, 0xC0D18003)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_ILLEGAL, 0xC0D18004)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_PACKET_NUMBER_WRONG, 0xC0D18005)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_ALREADY_EXISTS, 0xC0D18006)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NO_USER, 0xC0D18007)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_BOOTSTRAP_ONLY, 0xC0D18008)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NOT_BOOTSTRAP, 0xC0D18009)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NO_RIGHTS, 0xC0D1800A)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_PROGRAM_ERROR, 0xC0D1800B)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_CHECKSUM_WRONG, 0xC0D1800C)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_FIRMWARE_DOES_NOT_FIT, 0xC0D1800D)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_NO_FILE_TO_READ, 0xC0D1800F)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_FILE_HEADER_DOES_NOT_EXIST, 0xC0D18010)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_FLASH_PROBLEM, 0xC0D18011)
ECM_ERROR_RESULT(ECM_ERROR_FOE_ERROR_FILE_INCOMPATIBLE, 0xC0D18012)

/*
#define TLR_UNQ_NR_ECMV4_EOE             0xD0
*/

ECM_ERROR_RESULT(ECM_ERROR_EOE_INVALID_MAC_ADDRESS, 0xC0D00001)
ECM_ERROR_RESULT(ECM_ERROR_EOE_INVALID_CALLBACK_TYPE, 0xC0D00002)
ECM_ERROR_RESULT(ECM_ERROR_EOE_DESTINATION_UNREACHABLE, 0xC0D00003)
ECM_ERROR_RESULT(ECM_ERROR_EOE_INVALID_EOE_RESPONSE, 0xC0D00004)
ECM_ERROR_RESULT(ECM_ERROR_EOE_UNKNOWN_ERROR, 0xC0D00005)
ECM_ERROR_RESULT(ECM_ERROR_EOE_UNSPECIFIED_ERROR, 0xC0D00006)
ECM_ERROR_RESULT(ECM_ERROR_EOE_UNSUPPORTED_FRAME_TYPE, 0xC0D00007)
ECM_ERROR_RESULT(ECM_ERROR_EOE_NO_IP_SUPPORT, 0xC0D00008)
ECM_ERROR_RESULT(ECM_ERROR_EOE_DHCP_NOT_SUPPORTED, 0xC0D00009)
ECM_ERROR_RESULT(ECM_ERROR_EOE_NO_FILTER_SUPPORT, 0xC0D0000A)
ECM_ERROR_RESULT(ECM_ERROR_EOE_TIMEOUT, 0xC0D0000B)
ECM_ERROR_RESULT(ECM_ERROR_EOE_SHUTTING_DOWN, 0xC0D0000C)
ECM_ERROR_RESULT(ECM_ERROR_EOE_MASTER_ADDRESS_NOT_ALLOWED, 0xC0D0000D)
ECM_ERROR_RESULT(ECM_ERROR_EOE_CONFIGURATION_IS_NOT_OPEN, 0xC0D0000E)
ECM_ERROR_RESULT(ECM_ERROR_EOE_CONFIGURATION_IS_ALREADY_OPEN, 0xC0D0000F)
ECM_ERROR_RESULT(ECM_ERROR_EOE_DUPLICATE_IP_ADDRESS, 0xC0D00010)
ECM_ERROR_RESULT(ECM_ERROR_EOE_DUPLICATE_MAC_ADDRESS_ON_MULTIPLE_PORTS, 0xC0D00011)
ECM_ERROR_RESULT(ECM_ERROR_EOE_FRAME_TOO_LARGE, 0xC0D00012)
ECM_ERROR_RESULT(ECM_ERROR_EOE_IF_INITIALIZATION_ERROR, 0xC0D00013)
ECM_ERROR_RESULT(ECM_ERROR_EOE_IF_NO_FRAME_AVAILABLE, 0xC0D00014)
ECM_ERROR_RESULT(ECM_ERROR_EOE_LINK_DOWN, 0xC0D00015)
ECM_ERROR_RESULT(ECM_ERROR_EOE_REQUEST_DESTINATION_PROBLEM, 0xC0D00016)
ECM_ERROR_RESULT(ECM_ERROR_EOE_INVALID_FRAME_RECEIVED, 0xC0D00017)

/*
#define TLR_UNQ_NR_ECMV4_AOE             0xCE
 */
/* 0x0000-0xEFFF used for direct mapping of AoE return codes */
#ifndef _ECM_ERROR_RESULT_SKIP_MAP_AREA_CODES_
ECM_ERROR_RESULT(ECM_ERROR_AOE_MAPPED_START, 0xC0CE0000)
#endif
ECM_ERROR_RESULT(ECM_ERROR_AOE_TARGET_PORT_NOT_FOUND, 0xC0CE0006)
ECM_ERROR_RESULT(ECM_ERROR_AOE_TARGET_MACHINE_NOT_FOUND, 0xC0CE0007)
ECM_ERROR_RESULT(ECM_ERROR_AOE_SERVICE_NOT_SUPPORTED, 0xC0CE0701)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_INDEX_GROUP, 0xC0CE0702)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_INDEX_OFFSET, 0xC0CE0703)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_ACCESS, 0xC0CE0704)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_SIZE, 0xC0CE0705)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_DATA, 0xC0CE0706)
ECM_ERROR_RESULT(ECM_ERROR_AOE_NOTREADY, 0xC0CE0707)
ECM_ERROR_RESULT(ECM_ERROR_AOE_BUSY, 0xC0CE0708)
ECM_ERROR_RESULT(ECM_ERROR_AOE_NOMEMORY, 0xC0CE070A)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_PARAM, 0xC0CE070B)
ECM_ERROR_RESULT(ECM_ERROR_AOE_NOT_FOUND, 0xC0CE070C)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INCOMPATIBLE, 0xC0CE070E)
ECM_ERROR_RESULT(ECM_ERROR_AOE_WRONG_SLAVE_STATE, 0xC0CE0712)
ECM_ERROR_RESULT(ECM_ERROR_AOE_NOTINIT, 0xC0CE0718)
ECM_ERROR_RESULT(ECM_ERROR_AOE_DEVICE_TIMEOUT, 0xC0CE0719)
#ifndef _ECM_ERROR_RESULT_SKIP_MAP_AREA_CODES_
ECM_ERROR_RESULT(ECM_ERROR_AOE_MAPPED_END, 0xC0CEEFFF)
#endif

ECM_ERROR_RESULT(ECM_ERROR_AOE_SHUTTING_DOWN, 0xC0CEF001)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INITIALIZATION_ERROR, 0xC0CEF002)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_TRANSFER_HANDLE, 0xC0CEF003)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_TRANSFER_STATE, 0xC0CEF004)
ECM_ERROR_RESULT(ECM_ERROR_AOE_PROTOCOL_TIMEOUT, 0xC0CEF005)
ECM_ERROR_RESULT(ECM_ERROR_AOE_TRANSFER_SEGMENT_TOO_LONG, 0xC0CEF006)
ECM_ERROR_RESULT(ECM_ERROR_AOE_NO_MAILBOX_AVAILABLE, 0xC0CEF007)
ECM_ERROR_RESULT(ECM_ERROR_AOE_RECONFIGURATION_IN_PROGRESS, 0xC0CEF008)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_SLAVE_STATION_ADDRESS, 0xC0CEF009)
ECM_ERROR_RESULT(ECM_ERROR_AOE_TRANSFER_ABORTED, 0xC0CEF00A)
ECM_ERROR_RESULT(ECM_ERROR_AOE_REQUEST_DESTINATION_PROBLEM, 0xC0CEF00B)
ECM_ERROR_RESULT(ECM_ERROR_AOE_DUPLICATE_NETID, 0xC0CEF00C)
ECM_ERROR_RESULT(ECM_ERROR_AOE_INVALID_NETID_HANDLE, 0xC0CEF00D)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CONFIGURATION_IS_NOT_OPEN, 0xC0CE000E)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CONFIGURATION_IS_ALREADY_OPEN, 0xC0CE000F)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_INVALID_TRANSFER_HANDLE, 0xC0CEF010)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_INVALID_TRANSFER_STATE, 0xC0CEF011)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_TRANSFER_ABORTED, 0xC0CEF012)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_PROTOCOL_TIMEOUT, 0xC0CEF013)
ECM_ERROR_RESULT(ECM_ERROR_AOE_UNKNOWN_RETURN_CODE, 0xC0CEF014)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_UNKNOWN_AOE_ERROR, 0xC0CEF015)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_TRANSFER_SEGMENT_TOO_LONG, 0xC0CEF016)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_IS_INITIALIZING, 0xC0CEF017)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_REQUEST_DESTINATION_PROBLEM, 0xC0CEF018)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_MAX_SEGMENT_BYTES_TOO_LOW_FOR_FIRST_SEGMENT, 0xC0CEF019)
ECM_ERROR_RESULT(ECM_ERROR_AOE_CLIENT_INVALID_RESPONSE, 0xC0CEF01A)
/* #define TLR_UNQ_NR_ECMV4_MBXROUTER       0xDD */
ECM_ERROR_RESULT(ECM_ERROR_MBXROUTER_SHUTTING_DOWN, 0xC0DD0001)
ECM_ERROR_RESULT(ECM_ERROR_MBXROUTER_INITIALIZATION_ERROR, 0xC0DD0002)

/* #define TLR_UNQ_NR_ECMV4_IF              0xD6 */
ECM_ERROR_RESULT(ECM_ERROR_IF_COE_SUPPORT_NOT_AVAILABLE, 0xC0D60001)
ECM_ERROR_RESULT(ECM_ERROR_IF_SOE_SUPPORT_NOT_AVAILABLE, 0xC0D60002)
ECM_ERROR_RESULT(ECM_ERROR_IF_FOE_SUPPORT_NOT_AVAILABLE, 0xC0D60003)
ECM_ERROR_RESULT(ECM_ERROR_IF_AOE_SUPPORT_NOT_AVAILABLE, 0xC0D60004)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_TRANSPORT_TYPE, 0xC0D60005)
ECM_ERROR_RESULT(ECM_ERROR_IF_SOE_INVALID_DRIVE_NO, 0xC0D60006)
ECM_ERROR_RESULT(ECM_ERROR_IF_SOE_INVALID_ELEMENT_FLAGS, 0xC0D60007)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_SOE_TRANSFER_ID, 0xC0D60008)
ECM_ERROR_RESULT(ECM_ERROR_IF_TRANSFER_ABORTED, 0xC0D60009)
ECM_ERROR_RESULT(ECM_ERROR_IF_OUT_OF_PACKETS, 0xC0D6000A)
ECM_ERROR_RESULT(ECM_ERROR_IF_OUT_OF_TRANSFER_CONTEXTS, 0xC0D6000B)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_SUBINDEX_FOR_COMPLETE_ACCESS, 0xC0D6000C)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_COE_TRANSFER_ID, 0xC0D6000D)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_COE_SDOINFO_LISTTYPE, 0xC0D6000E)
ECM_ERROR_RESULT(ECM_ERROR_IF_FILE_READ_ERROR, 0xC0D6000F)
ECM_ERROR_RESULT(ECM_ERROR_IF_COULD_NOT_OPEN_FILE, 0xC0D60010)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_CONFIG_NXD, 0xC0D60011)
ECM_ERROR_RESULT(ECM_ERROR_IF_CONFIG_NXD_WITHOUT_SLAVES, 0xC0D60012)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_FILE_NAME, 0xC0D60013)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_FOE_TRANSFER_ID, 0xC0D60014)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_GET_TOPOLOGY_TRANSFER_ID, 0xC0D60015)
ECM_ERROR_RESULT(ECM_ERROR_IF_INVALID_AOE_TRANSFER_ID, 0xC0D60016)
ECM_ERROR_RESULT(ECM_ERROR_IF_ACFG_SUPPORT_NOT_AVAILABLE, 0xC0D60017)
ECM_ERROR_RESULT(ECM_ERROR_IF_EOE_SUPPORT_NOT_AVAILABLE, 0xC0D60018)

/* #define TLR_UNQ_NR_ECMV4_ACFG              0xDE */
ECM_ERROR_RESULT(ECM_ERROR_ACFG_UNSUPPORTED_PROTOCOL, 0xC0DE0001)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_UNSUPPORTED_COE_DEVICE_PROFILE, 0xC0DE0002)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_COE_SUPPORT_NOT_AVAILABLE, 0xC0DE0003)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_NON_CONTINUOUS_SM_FMMU_MAPPING_FOUND, 0xC0DE0004)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_TOPOLOGY_ERROR_DETECTED, 0xC0DE0005)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_INTERNAL_ERROR, 0xC0DE0006)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_INVALID_FIRST_ASSIGNED_FIRST_STATION_ADDRESS, 0xC0DE0007)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_INVALID_TARGET_STATE, 0xC0DE0008)

ECM_ERROR_RESULT(ECM_ERROR_ACFG_REQUEST_DESTINATION_PROBLEM, 0xC0DEF001)
ECM_ERROR_RESULT(ECM_ERROR_ACFG_INITIALIZATION_ERROR, 0xC0DEF002)

/* #define TLR_UNQ_NR_ECMV4_ALSTATCODE      0xD5 (area for direct mapping of EtherCAT AlStatusCodes) */
#define ECM_ERROR_MAP_ALSTATUSCODE(v) ((ECM_ERROR_CODE_E)(0xC0D50000 | ((v) & 0xFFFF)))
#ifndef ECM_ERROR_RESULT_ALSTATUSCODE
#define ECM_ERROR_RESULT_ALSTATUSCODE(x, v) x = 0xC0D50000 | ((v) & 0xFFFF),
#endif
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_UNSPECIFIED_ERROR, 0xC0D50001)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_MEMORY, 0xC0D50002)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_DEVICE_SETUP, 0xC0D50003)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_REQUESTED_STATE_CHANGE, 0xC0D50011)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_UNKNOWN_REQUESTED_STATE, 0xC0D50012)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_BOOTSTRAP_NOT_SUPPORTED, 0xC0D50013)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_VALID_FIRMWARE, 0xC0D50014)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_BOOT_MAILBOX_CONFIGURATION, 0xC0D50015)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_PREOP_MAILBOX_CONFIGURATION, 0xC0D50016)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_SYNC_MANAGER_CONFIGURATION, 0xC0D50017)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_VALID_INPUTS_AVAILABLE, 0xC0D50018)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_VALID_OUTPUTS, 0xC0D50019)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SYNCHRONIZATION_ERROR, 0xC0D5001A)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SYNC_MANAGER_WATCHDOG, 0xC0D5001B)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_SYNC_MANAGER_TYPES, 0xC0D5001C)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_OUTPUT_CONFIGURATION, 0xC0D5001D)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_INPUT_CONFIGURATION, 0xC0D5001E)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_WATCHDOG_CONFIGURATION, 0xC0D5001F)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SLAVE_NEEDS_COLD_START, 0xC0D50020)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SLAVE_NEEDS_INIT, 0xC0D50021)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SLAVE_NEEDS_PREOP, 0xC0D50022)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SLAVE_NEEDS_SAFEOP, 0xC0D50023)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_INPUT_MAPPING, 0xC0D50024)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_OUTPUT_MAPPING, 0xC0D50025)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INCONSISTENT_SETTINGS, 0xC0D50026)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_FREERUN_NOT_SUPPORTED, 0xC0D50027)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SYNCMODE_NOT_SUPPORTED, 0xC0D50028)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_FREERUN_NEEDS_3BUFFER_MODE, 0xC0D50029)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_BACKGROUND_WATCHDOG, 0xC0D5002A)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_VALID_INPUTS_AND_OUTPUTS, 0xC0D5002B)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_FATAL_SYNC_ERROR, 0xC0D5002C)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_NO_SYNC_ERROR, 0xC0D5002D)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_DC_SYNC_CONFIGURATION, 0xC0D50030)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_INVALID_DC_LATCH_CONFIGURATION, 0xC0D50031)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_PLL_ERROR, 0xC0D50032)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DC_SYNC_IO_ERROR, 0xC0D50033)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DC_SYNC_TIMEOUT_ERROR, 0xC0D50034)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DC_INVALID_SYNC_CYCLE_TIME, 0xC0D50035)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DC_SYNC0_CYCLE_TIME, 0xC0D50036)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DC_SYNC1_CYCLE_TIME, 0xC0D50037)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_AOE, 0xC0D50041)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_EOE, 0xC0D50042)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_COE, 0xC0D50043)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_FOE, 0xC0D50044)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_SOE, 0xC0D50045)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_MBX_VOE, 0xC0D5004F)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_EEPROM_NO_ACCESS, 0xC0D50050)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_EEPROM_ERROR, 0xC0D50051)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_SLAVE_RESTARTED_LOCALLY, 0xC0D50060)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_DEVICE_IDENTIFICATION_VALUE_UPDATED, 0xC0D50061)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_APPLICATION_CONTROLLER_AVAILABLE, 0xC0D500F0)

#ifndef _ECM_ERROR_RESULT_SKIP_MAP_AREA_CODES_
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_VENDOR_SPECIFIC_CODE_START, 0xC0D58000)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_ALSTATCODE_VENDOR_SPECIFIC_CODE_END, 0xC0D5FFFF)

ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_AOE_DEVICE_ERROR_START, 0xC0F80000)
ECM_ERROR_RESULT_ALSTATUSCODE(ECM_ERROR_AOE_DEVICE_ERROR_END, 0xC0F8FFFF)
#endif

ECM_ERROR_TABLE_END

#endif
